// Autor: Ivan Katanic

#include <algorithm>
#include <cassert>
#include <cstring>
#include <iostream>
#include <map>

using namespace std;

const int MAX = 300030;

struct Loga {
  int L[MAX];
  void update(int x, int v) {
    for (++x; x < MAX; x += x&-x)
      L[x] = max(L[x], v);
  }
  int getMax(int x) {
    int r = 0;
    for (++x; x; x -= x&-x)
      r = max(r, L[x]);
    return r;
  }
};

Loga pre, suf;
int fl[MAX], fr[MAX];
map<int, vector<int>, greater<int>> v;

int main(void) {
  int N;
  scanf("%d", &N);
  for (int i = 0; i < N; ++i) {
    int h;
    scanf("%d", &h);
    v[h].push_back(i);
  }

  for (auto& p: v) {
    for (int i : p.second) {
      fl[i] = pre.getMax(i) + 1;
      fr[i] = suf.getMax(N-i-1) + 1;
    }
    for (int i : p.second) {
      pre.update(i, fr[i]);
      suf.update(N-i-1, fl[i]);
    }
  }

  for (int i = 0; i < N; ++i) {
    if (i) putchar(' ' );
    printf("%d", max(fl[i], fr[i]));
  }
  putchar('\n');
  return 0;
}
